function kE = mfs_ke(elem)

# usage: kE = mfs_ke(elem)
#
# Input  elem     Structure containing data of one element
#
# Output kE       Element stiffness matrix
#
# The function computes the stiffness matrix of a 2-dimensional 
# quadratic triangular isoparametric membrane element with 6 nodes.
#
# -------------------------------------------------------------------

  persistent ng; persistent r;
  persistent  s; persistent w;

# Initialize Gauss integration

  if (isempty(ng))
     ng = 3;
     f  = 1 / 6;
     r  = [0.5, 0.5, 0];
     s  = [0, 0.5, 0.5];
     w  = f * [1, 1, 1];
  end

# Material matrix

  E = mfs_emat2d(elem.mat);

# Initialization

  kE = zeros(12, 12,"double");

# Integration Loop

  t    = elem.geom.t;
  coor = elem.coor;
  for n = 1 : ng
      [BE, JE] = mfs_BE_t6(r(n), s(n), coor(:, 1), coor(:, 2));
      wdV = w(n) * JE * t;
      kE = kE + BE' * (E * wdV) * BE;
  end

end
