function m = mfs_mce(elem)

# usage: m = mfs_mce(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the consistent mass matrix of a 2-dimensional
# triangular isoparametric membrane element with 6 nodes.
#
# -------------------------------------------------------------------

  persistent ng; persistent r;
  persistent  s; persistent w;

# Initialize Gauss integration (cf. Bathe)

  if (isempty(ng))
     ng = 3;
     f  = 1 / 6;
     r  = [0.5, 0.5, 0];
     s  = [0, 0.5, 0.5];
     w  = f * [1, 1, 1];
  end

# Initialize result

  m = sparse(12, 12);

# Mass density

  if (isfield(elem.mat, "rho"))
     rho = elem.mat.rho;
  else
     return;
  end

# Degree of freedom indices

  u = 1 : 2 : 11;
  v = 2 : 2 : 12; 

# Integration loop

  m66 = zeros(6, 6, "double");

  coor = elem.coor;
  for n = 1 : ng
      JE = mfs_JE_t6(r(n), s(n), coor(:, 1), coor(:, 2));
      wdA = w(n) * JE;
      N   = mfs_NE_t6(r(n), s(n));
      m66 += N' * N * wdA;
  end

  m66     = rho * elem.geom.t * m66;
  m(u, u) = m66;
  m(v, v) = m66;

end
