function m = mfs_mle(elem)

# usage: m = mfs_mle(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the lumped mass matrix of a 2-dimensional
# triangular isoparametric membrane element with 6 nodes.
#
# -------------------------------------------------------------------

  persistent ng; persistent r;
  persistent  s; persistent w;

# Initialize Gauss integration (cf. Bathe)

  if (isempty(ng))
     ng = 3;
     f  = 1 / 6;
     r  = [0.5, 0.5, 0];
     s  = [0, 0.5, 0.5];
     w  = f * [1, 1, 1];
  end

# Mass density

  if (isfield(elem.mat, "rho"))
     rho = elem.mat.rho;
  else
     m = sparse(12, 12);
     return;
  end

# Area

  A    = 0;
  coor = elem.coor;

  for n = 1 : ng
      JE = mfs_JE_t6(r(n), s(n), coor(:, 1), coor(:, 2));
      A += w(n) * JE;
  end

# Mass matrix

  mp = rho * elem.geom.t * A / 9;
  m  = mp * speye(12);
  m(7 : 12, 7 : 12) = 2 * m(7 : 12, 7 : 12);

end
