function eldata = mfs_defelt()

# usage: eldata = mfs_defelt()
#
# Output eldata   Structure with element type data:
#                   name     element name
#                   nelnod   number of element nodes
#                   ndofnod  number of dofs per node
#                   mat      indicates if material data are needed (0 or 1)
#                   geom     indicates if geometrical data are needed (0 or 1)
#                   gmshid   gmsh element type
#                   rtype    result type: 1 = beam results
#                   axes     axes type:   2 = beam
#
# The function returns the data of a 3-dimensional b2-element.
#
# -----------------------------------------------------------------------------

  eldata = struct("name", "b2",
                  "nelnod",  2,
                  "ndofnod", 6, 
                  "mat",     1,
                  "geom",    1,
                  "gmshid",  1,
                  "rtype",   1,
                  "axes",    2);

end
