function mfs_pltelt(nofelt, elem);

# usage: mfs_pltelt(nofelt, elem)
#
# Input nofelt    Number of elements 
#       elem      Structure with element data
#
# The function plots 3-dimensional b2 elements.
#
# Description of the element structure:
#
#   elem.id                  Element identifier
#   elem.nodes(:)            Identifiers of element nodal points
#   elem.coor(:, 2)          Coordinates of element nodal points
#   elem.ects(:)             Element connectivity table
#   elem.mat                 Structure with element material data
#   elem.geom                Structure with element geometry data 
#
# ------------------------------------------------------------------------

  global pltparm;


# Plot elements

  lw   = get(0, "defaultlinelinewidth");
  lwb  = 1.5 * lw;

  coor = [elem.coor];
  line(coor(:, 1 : 3 : end), coor(:, 2 : 3 : end),
       coor(:, 3 : 3 : end), "linewidth", lwb, "color", pltparm.color);

# Plot beam axis

  if (pltparm.beamaxis)
     for nel = 1 : nofelt
         d = elem(nel).coor(2, :) - elem(nel).coor(1, :);
         L = norm(d);
         if (L == 0)
            error("mfs_pl3d_b2: Beam %4d has zero length\n", ...
                   elem(nel).id);
         end
         ex = d' / L;
         ez = elem(nel).geom.v' - (elem(nel).geom.v * ex) * ex;
         Lz = norm(ez);
         if (Lz == 0)
            error("mfs_pl3d_b2: Beam %4d has bad axes\n", ...
                   elem(nel).id);
         end
         ez = pltparm.scalax * ez * L / Lz;
         x(1) = elem(nel).coor(1, 1);
         y(1) = elem(nel).coor(1, 2);
         z(1) = elem(nel).coor(1, 3);
         x(2) = x(1) + ez(1);
         y(2) = y(1) + ez(2);
         z(2) = z(1) + ez(3);
         line(x, y, z, "color", "red");
     end
  end

# Plot element identifiers

  if (pltparm.eltid == 1)
     for nel = 1 : nofelt
         x = mean(elem(nel).coor(:, 1));
         y = mean(elem(nel).coor(:, 2));
         z = mean(elem(nel).coor(:, 3));
         label = sprintf("%d", elem(nel).id);
         text(x, y, z, label);
     end
  end

end
