function mfs_prtelt(fid, nofelt, elem, lc, type)

# usage: mfs_prtelt(fid, nofelt, elem, lc, type)
#
# Input  fid       File handle
#        nofelt    Number of elements
#        elem(:)   Structure with element results
#        lc        Loadcase
#        type      Result type:
#                  "resultant"   Stress resultants
#                  "cresultant"  Complex stress resultants
#
# This function prints element results of 3-dimensional beam elements.
#
# ------------------------------------------------------------------------

  switch type

  case "resultant"

     fprintf(fid, "  Beam elements:\n\n");
     fprintf(fid, "  element        N           Qy           Qz");
     fprintf(fid, "           Mx           My           Mz\n");
     fprintf(fid, "  ------------------------------------------");
     fprintf(fid, "--------------------------------------------\n");

     fme = "   %10.3e   %10.3e   %10.3e";
     fmt = ["   %6d", fme, fme, "\n"];

     for nel = 1 : nofelt
         fprintf(fid, fmt, elem(nel).id, elem(nel).results.rslt(:, lc));
     end

     fprintf(fid, "\n");

  case "cresultant"

     fprintf(fid, "  Beam elements:\n\n");
     fprintf(fid, "  element           N           Qy           Qz");
     fprintf(fid, "           Mx           My           Mz\n");
     fprintf(fid, "  ---------------------------------------------");
     fprintf(fid, "--------------------------------------------\n");

     fme = "   %10.3e   %10.3e   %10.3e";
     fmr = ["   %6d Re", fme, fme, "\n"];
     fmi = ["          Im", fme, fme, "\n"];

     for nel = 1 : nofelt
         fprintf(fid, fmr, elem(nel).id, real(elem(nel).results.rslt(:, lc)));
         fprintf(fid, fmi, imag(elem(nel).results.rslt(:, lc)));
     end

     fprintf(fid, "\n");

  end

end
