function eldata = mfs_defelt()

# usage: eldata = mfs_defelt()
#
# Output eldata   Structure with element type data:
#                   name     element name
#                   nelnod   number of element nodes
#                   ndofnod  number of dofs per node
#                   mat      indicates if material data are needed (0 or 1)
#                   geom     indicates if geometrical data are needed (0 or 1)
#                   gmshid   gmsh element type
#                   rtype    result type: 0 = no results
#                   axes     axes type:   0 = none
#
# The function returns the data of a 3-dimensional m1-element.
#
# -----------------------------------------------------------------------------

  eldata = struct("name", "m1",
                  "nelnod",  1,
                  "ndofnod", 3, 
                  "mat",     0,
                  "geom",    1,
                  "gmshid", 15,
                  "rtype",   0,
                  "axes",    0);

end
