function mfs_pltelt(nofelt, elem);

# usage: mfs_pltelt(nofelt, elem)
#
# Input nofelt    Number of elements 
#       elem      Structure with element data
#
# The function plots 3-dimensional m1 elements.
#
# Description of the element structure:
#
#   elem.id                  Element identifier
#   elem.nodes(:)            Identifiers of element nodal points
#   elem.coor(:, 2)          Coordinates of element nodal points
#   elem.ects(:)             Element connectivity table
#   elem.mat                 Structure with element material data
#   elem.geom                Structure with element geometry data 
#
# ------------------------------------------------------------------------

  global pltparm;

# Plot elements

  for nel = 1 : nofelt
      x = elem(nel).coor(1);
      y = elem(nel).coor(2);
      z = elem(nel).coor(3);
      text(x, y, z, "o","fontsize", 20, "fontweight", "bold", ...
           "horizontalalignment", "center");
  end

# Plot element identifiers

  if (pltparm.eltid == 1)
     for nel = 1 : nofelt
         label = sprintf("%d", elem(nel).id);
         x = elem(nel).coor(1);
         y = elem(nel).coor(2);
         z = elem(nel).coor(3);
         text(x, y, z, label, "fontsize", pltparm.fontsize);
     end
  end

end
