function rc = mfs_chkelt(msg, elem, Lmin)

# usage: rc = mfs_chkelt(msg, elem, Lmin)
#
# Input  msg    File handle of message file 
#        elem   Structure with element data
#        Lmin   Minimum element length
#
# Ouput  rc     Return code: 0 means no erros
#                            1 means erros
#
# The function performs basic checks of 2-dimensional rigid body mass.
#
# ----------------------------------------------------------------------------

# Initialize

  geom_fields = {"m", "Jx", "Jy", "Jz", "Jxy", "Jxz", "Jyz"};
  rc  = 0;

# Loop over elements

  for el = elem

      geom = el.geom;
      rce = mfs_checkfields2(msg, geom, geom_fields, "Element", el.id);
      if (! rce)
         if (geom.m < 0)
            fprintf(msg, "*E* Element %5d: Illegal value of \"geom.m\"\n",
                    el.id);
            rce = 1;
         end
         for Jm = {"Jx", "Jy", "Jz"}
             if (getfield(geom, Jm{1}) < 0)
                fprintf(msg, "*E* Element %5d: Illegal value of ", el.id);
                fprintf(msg, "\"geom.%s\"\n", Jm{1});
                rce = 1;
             end
         end
         J = [geom.Jx, geom.Jxy, geom.Jxz; 
              geom.Jxy, geom.Jy, geom.Jyz; 
              geom.Jxz, geom.Jyz, geom.Jz];
         if (det(J) < 0)
            fprintf(msg, "*E* Element %5d: Inertia tensor not ", el.id);
            fprintf(msg, "positive definite\n");
            rce = 1;
         end
      end

      rce = rce | mfs_checkfields3(msg, geom, geom_fields, "Element", 
                                   el.id);

      rc = rc | rce;

  end

end
