function m = mfs_mle(elem)

# usage: m = mfs_mle(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the mass matrix of a 2-dimensional rigid body
# element.
#
# -------------------------------------------------------------------

  J = zeros(3, 3, "double");

  J(1, 1)  = elem.geom.Jx;
  J(2, 2)  = elem.geom.Jy;
  J(3, 3)  = elem.geom.Jz;
  J(1, 2)  = elem.geom.Jxy;
  J(2, 1)  = elem.geom.Jxy;
  J(1, 3)  = elem.geom.Jxz;
  J(3, 1)  = elem.geom.Jxz;
  J(2, 3)  = elem.geom.Jyz;
  J(3, 2)  = elem.geom.Jyz;

  m = zeros(6, 6, "double");
  m(1 : 3, 1 : 3) = elem.geom.m * eye(3, 3, "double");
  m(4 : 6, 4 : 6) = J;

end
