function m = mfs_mce(elem)

# usage: m = mfs_mce(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the consistent mass matrix of a 3-dimensional
# quadrilateral isoparametric membrane element with 4 nodes.
#
# -------------------------------------------------------------------

  persistent first = 1;
  persistent ng; persistent r; persistent  s; persistent w;
  persistent iu; persistent iv; persistent iw; % Dof indices

# Initialize

  if (first)
     first = 0;
     ng = 4;
     f  = 1 / sqrt(3);
     r  = [ -f, f, -f, f];
     s  = [ -f, -f, f, f];
     w  = [ 1, 1, 1, 1];
     iu = 1 : 3 : 10; iv = iu + 1; iw = iv + 1;
  end

# Mass density

  if (isfield(elem.mat, "rho"))
     rho = elem.mat.rho;
  else
     m = sparse(12, 12);
     return;
  end

# Transformation to element coordinate system

  [x, y, TE] = mfs_esys(elem.coor, 2, elem.geom);

# Mass matrix in element coordinate system

  m44 = zeros(4, 4, "double");

  for n = 1 : ng
      JE = mfs_JE_q4(r(n), s(n), x, y);
      wdA = w(n) * JE;
      N   = mfs_NE_q4(r(n), s(n));
      m44 += N' * N * wdA;
  end

  mE  = sparse(12, 12);
  m44 = rho * elem.geom.t * m44;

  mE(iu, iu) = m44; mE(iv, iv) = m44; mE(iw, iw) = m44;

# Mass matrix in global coordinate system

  m = TE' * mE * TE;

end
