function mfs_pltelt(nofelt, elem);

# usage: mfs_pltelt(nofelt, elem)
#
# Input nofelt    Number of elements 
#       elem      Structure with element data
#
# The function plots q4 elements.
#
# Description of the element structure:
#
#   elem.id                  Element identifier
#   elem.nodes(:)            Identifiers of element nodal points
#   elem.coor(:, 3)          Coordinates of element nodal points
#   elem.ects(:)             Element connectivity table
#   elem.mat                 Structure with element material data
#   elem.geom                Structure with element geometry data 
#
# ------------------------------------------------------------------------

  global pltparm;

  nx = [1, 2, 3, 4, 1];

# Plot elements

  for nel = 1 : nofelt
      x(:, nel) = elem(nel).coor(nx, 1);
      y(:, nel) = elem(nel).coor(nx, 2);
      z(:, nel) = elem(nel).coor(nx, 3);
  end
  line(x, y, z, "linewidth", 1, "color", pltparm.color);

# Plot element identifiers

  if (pltparm.eltid == 1)
     for nel = 1 : nofelt
         xm = mean(elem(nel).coor(:, 1));
         ym = mean(elem(nel).coor(:, 2));
         zm = mean(elem(nel).coor(:, 3));
         label = sprintf("%i", elem(nel).id);
         text(xm, ym, zm, label, "fontsize", pltparm.fontsize);
     end
  end

end
