function m = mfs_mle(elem)

# usage: m = mfs_mle(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the lumped mass matrix of a 3-dimensional
# quadrilateral membrane element with 4 nodes with drilling dofs.
#
# -------------------------------------------------------------------

  persistent ib; persistent tdofs;

  if (isempty(ib))
     ib    = [2, 3, 4, 1];
     tdofs = [1, 2, 3, 7, 8, 9, 13, 14, 15, 19, 20, 21];
  end

# Mass density

  if (isfield(elem.mat, "rho"))
     rho = elem.mat.rho;
  else
     m = sparse(24, 24);
     return;
  end

# Area

  coor  = elem.coor;
  edges = coor(ib, :) - coor;
  n     = cross(edges([1, 3], :), edges([2, 4], :));
  A     = mean(norm(n, "rows"));

# Mass matrix

  v        = zeros(24, 1, "double");
  v(tdofs) = 0.25 * rho * elem.geom.t * A;
  m        = spdiags(v, 0, 24, 24);

end
