function m = mfs_mce(elem)

# usage: m = mfs_mce(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the consistent mass matrix of a 3-dimensional
# rod element.
#
# -------------------------------------------------------------------

# Mass of the element

  if (isfield(elem.mat, "rho"))
     d  = elem.coor(2, :) - elem.coor(1, :);
     L  = norm(d);
     m0 = L * elem.geom.A * elem.mat.rho;
  else
     m = sparse(6, 6);
     return;
  end

# Mass matrix

  m = (m0 / 6) * [ 2, 0, 0, 1, 0, 0;
                   0, 2, 0, 0, 1, 0;
                   0, 0, 2, 0, 0, 1;
                   1, 0, 0, 2, 0, 0;
                   0, 1, 0, 0, 2, 0;
                   0, 0, 1, 0, 0, 2];

end
