function rc = mfs_chkelt(msg, elem, Lmin)

# usage: rc = mfs_chkelt(msg, elem, Lmin)
#
# Input  msg    File handle of message file
#        elem   Structure with element data
#        Lmin   Minimum element length
#
# Ouput  rc     Return code: 0 means no erros
#                            1 means erros
#
# The function performs basic checks of s3 shell elements.
#
# ----------------------------------------------------------------------------

# Initialize

  geom_fields_req = {"t"};
  geom_fields_leg = {"t", "zo", "ka", "l2trat", "wtol"};
  rc  = 0;

# Loop over elements

  for el = elem

      geom = el.geom;
      rce = mfs_checkfields2(msg, geom, geom_fields_req, "Element",
                             el.id);
      if (! rce && geom.t <= 0)
         fprintf(msg, "*E* Element %6d: Illegal value of \"geom.t\"\n", 
                 el.id);
         rce = 1;
      end

      rce = rce | mfs_checkfields3(msg, geom, geom_fields_leg, 
                                   "Element", el.id);
      rce = rce | mfs_chkmat3d(msg, el.mat, el.id);

      if (isfield(geom, "ka") && geom.ka < 0)
         fprintf(msg, "*E* Element %6d: Illegal value of \"geom.ka\"\n",
                 el.id);
         rce = 1;
      end

      if (isfield(geom, "zo"))
         d1 = norm(el.coor(2, :) - el.coor(1, :));
         d2 = norm(el.coor(3, :) - el.coor(2, :));
         d3 = norm(el.coor(1, :) - el.coor(3, :));
         dm = max([d1, d2, d3]);
         zorel = abs(geom.zo) / dm;
         if (zorel > 0.2)
            fprintf(msg, "*W* Element %6d: ", el.id);
            fprintf(msg, " Large offset may cause numerical problems");
            fprintf(msg, " (%6.2f %% of length)\n", 100 * zorel);
         end
      end

      rc = rc | rce;

  end


end
