function eldata = mfs_defelt()

# usage: eldata = mfs_defelt()
#
# Output eldata   Structure with element type data:
#                   name     element name 
#                   nelnod   number of element nodes
#                   ndofnod  number of dofs per node
#                   mat      indicates if material data are needed (0 or 1)
#                   geom     indicates if geometrical data are needed (0 or 1)
#                   gmshid   gmsh element type
#                   rtype    result type: 4 = shell results
#                   axes     axes type:   4 = triangle
#
# The function returns the data of an s3 shell element
#
# -----------------------------------------------------------------------------

  eldata = struct("name",  "s3",
                  "nelnod",   3,
                  "ndofnod",  6, 
                  "mat",      1,
                  "geom",     1,
                  "gmshid",   2,
                  "rtype",    4,
                  "axes",     3);

end
