function m = mfs_mle(elem)

# usage: m = mfs_mle(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the lumped mass matrix of a 3-dimensional
# triangular shell element with 3 nodes.
#
# -------------------------------------------------------------------

  persistent first = 1;
  persistent mdofs; % Membran degrees of freedom

# Initialite

  if (first)
     first = 0;
     mdofs = [1 : 3, 7 : 9, 13 : 15];
  end

  m = sparse(18, 18);

# Mass density

  if (isfield(elem.mat, "rho"))
     rho = elem.mat.rho;
  else
     return;
  end

# Edges

  coor = elem.coor;

  e12 = coor(2, :) - coor(1, :);
  e13 = coor(3, :) - coor(1, :);

# Area (divided by 3)

  A = norm(cross(e12, e13)) / 6;

# Mass matrix

  m(mdofs, mdofs) = rho * elem.geom.t * A * speye(9);

end
