function mfs_chkwarp(msg, id, coor)

# usage: mfs_chkwarp(msg, id, coor)
#
# Input msg          File handle of message file
#       id           Element identifiers
#       coor(4, 3)   Coordinates of element nodes
#
# The function checks the warping of a quadrilateral shell element.
# If the element is too warped, a warning message is issued.
#
# --------------------------------------------------------------------

# Origin

  C = mean(coor);                  % Centre of element

# Basis vectors of element coordinate system

  M23 = mean(coor([2, 3], :));     % Midpoint between points 2 and 3
  M34 = mean(coor([3, 4], :));     % Midpoint between points 3 and 4

  bx = M23 - C;
  L1 = norm(bx); bx = bx / L1;
  c2 = M34 - C;
  L2 = norm(c2); c2 = c2 / L2;
  bz = cross(bx, c2);
  by = cross(bz, bx);

  Lref = 0.5 * (L1 + L2);

# Check nodal point offset

  zp = (coor(1, :) - C) * bz';

  if (abs(zp) > 1e-3 * Lref)
     fprintf(msg, "*W* Element %5d: Warping angle about %6.4f rad\n", 
             id, abs(zp) / Lref);
  end

end
