function eldata = mfs_defelt()

# usage: eldata = mfs_defelt()
#
# Output eldata   Structure with element type data:
#                   name     element name 
#                   nelnod   number of element nodes
#                   ndofnod  number of dofs per node
#                   mat      indicates if material data are needed (0 or 1)
#                   geom     indicates if geometrical data are needed (0 or 1)
#                   gmshid   gmsh element type
#                   rtype    result type: 4 = shell results
#                   axes     axes type:   4 = quadrangle
#
# The function returns the data of an s4 shell element
#
# -----------------------------------------------------------------------------

  eldata = struct("name",  "s4",
                  "nelnod",   4,
                  "ndofnod",  6, 
                  "mat",      1,
                  "geom",     1,
                  "gmshid",   3,
                  "rtype",    4,
                  "axes",     4);

end
