function kE = mfs_ke(elem)

# usage: kE = mfs_ke(elem)
#
# Input  elem     Structure containing data of one element
#        id       Element identifier
#
# Output kE       Element stiffness matrix
#
# The function computes the stiffness matrix of a linear 3-dimensional
# triangular isoparametric membrane element with 3 nodes.
#
# ------------------------------------------------------------------------

# Material matrix

  E = mfs_emat2d(elem.mat);

# Transformation to element coordinate system

  [x, y, TE] = mfs_esys(elem.coor, 1);

# Strain-displacement transformation matrix

  [BE, JE] = mfs_BE_t3(x, y);

# Stiffness matrix in elment coordinate system

  kEE = BE' * (0.5 * elem.geom.t * JE * E) * BE;

# Stiffness matrix in global coordinate system

  kE = TE' * kEE * TE;

end
