function m = mfs_mle(elem)

# usage: m = mfs_mle(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the lumped mass matrix of a 3-dimensional
# triangular isoparametric membrane element with 3 nodes.
#
# -------------------------------------------------------------------

# Mass density

  if (isfield(elem.mat, "rho"))
     rho = elem.mat.rho;
  else
     m = sparse(9, 9);
     return;
  end

# Edges

  coor = elem.coor;

  e12 = coor(2, :) - coor(1, :);
  e13 = coor(3, :) - coor(1, :);

# Area (divided by 3)

  A = norm(cross(e12, e13)) / 6;

# Mass matrix

  m = rho * elem.geom.t * A * speye(9);

end
