function mfs_prtelt(fid, nofelt, elem, lc, type)

# usage: mfs_prtelt(fid, nofelt, elem, lc, type)
#
# Input  fid       File handle
#        nofelt    Number of elements
#        elem(:)   Structure with element results
#        lc        Loadcase
#        type      Result type: 
#                  "stress"   Stresses
#                  "strain"   Strains
#                  "cstress"  Complex stresses
#                  "cstrain"  Complex strains
#
# This function prints element results of 3-dimensional t3 elements.
#
# ------------------------------------------------------------------------

  switch type

  case "stress"
     mfs_prtstress_membrane(fid, nofelt, elem, lc, 0);

  case "cstress"
     mfs_prtstress_membrane(fid, nofelt, elem, lc, 1);

  case "strain"
     mfs_prtstrain_membrane(fid, nofelt, elem, lc, 0);

  case "cstrain"
     mfs_prtstrain_membrane(fid, nofelt, elem, lc, 1);

  end

end
