function rc = mfs_chkelt(msg, elem, Lmin)

# usage: rc = mfs_chkelt(msg, elem, Lmin)
#
# Input  msg    File handle of message file
#        elem   Structure with element data
#        Lmin   Minimum element length
#
# Ouput  rc     Return code: 0 means no erros
#                            1 means erros
#
# The function performs basic checks of 3-dimensional t3r elements.
#
# ----------------------------------------------------------------------------

# Initialize

  geom_fields_req = {"t"};
  geom_fields_leg = {"t", "wtol"};
  rc  = 0;

# Loop over elements

  for el = elem

      geom = el.geom;
      rce = mfs_checkfields2(msg, geom, geom_fields_req, "Element", el.id);
      if (! rce && geom.t <= 0)
         fprintf(msg, "*E* Element %5d: Illegal value of \"geom.t\"\n", 
                 el.id);
         rce = 1;
      end

      rce = rce | mfs_checkfields3(msg, geom, geom_fields_leg, "Element", 
                                   el.id);
      rce = rce | mfs_chkmat3d(msg, el.mat, el.id);

      rc = rc | rce;

  end

end
