function eldata = mfs_defelt()

# usage: eldata = mfs_defelt()
#
# Output eldata   Structure with element type data:
#                   name     element name 
#                   nelnod   number of element nodes
#                   ndofnod  number of dofs per node
#                   mat      indicates if material data are needed (0 or 1)
#                   geom     indicates if geometrical data are needed (0 or 1)
#                   gmshid   gmsh element type
#                   rtype    result type: 3 = plane stress
#                   axes     axes type:   3 = triangle
#
# The function returns the data of a 3-dimensional t3r-element.
#
# -----------------------------------------------------------------------------

  eldata = struct("name", "t3r",
                  "nelnod",   3,
                  "ndofnod",  6, 
                  "mat",      1,
                  "geom",     1,
                  "gmshid",   2,
                  "rtype",    3,
                  "axes",     3);

end
