function m = mfs_mle(elem)

# usage: m = mfs_mle(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the lumped mass matrix of a 3-dimensional
# triangular membrane element with 4 nodes with drilling dofs.
#
# -------------------------------------------------------------------

  persistent ib; persistent tdofs;

  if (isempty(ib))
     ib    = [2, 3];
     tdofs = [1, 2, 3, 7, 8, 9, 13, 14, 15];
  end

# Mass density

  if (isfield(elem.mat, "rho"))
     rho = elem.mat.rho;
  else
     m = sparse(18, 18);
     return;
  end

# Area (divided by 3)

  coor  = elem.coor;
  edges = coor(ib, :) - coor(1, :);
  n     = cross(edges(1, :), edges(2, :));
  A     = norm(n, "rows") / 6;

# Mass matrix

  v        = zeros(18, 1, "double");
  v(tdofs) = rho * elem.geom.t * A;
  m        = spdiags(v, 0, 18, 18);

end
