function relem = mfs_reselt(nofelt, elem, disp, class, varargin)

# usage: relem = mfs_reselt(nofelt, elem, disp, class, varargin)
#
# Input  nofelt      Number of elements
#        elem(:)     Structure array with element data
#        disp(:, :)  Displacement matrix
#        class       Response class
#
# Output relem       Structure containing element results
#
# with
#
#        relem.id              Element identifier
#        relem.nofpnt          Number of result points
#        relem.coor(nofpnt, 3) Coordinates of result points
#        relem.rtype           result type:  0 = no results
#                                            1 = beam results
#                                            2 = rod results
#                                            3 = plane stress
#        relem.results         Structure with results (depends on
#                              result type)
#
# This function computes the results of 3-dimensional elements.
#
# The variable argument list contains additional arguments depending
# on the class:
#
#    statresp:    none
#    freqresp:    varargin{1}      Circular excitation frequency
#
# -------------------------------------------------------------------

  eltids = num2cell([elem.id]);
  relem  = struct("id", eltids, "rtype", 0);

end
