function [BE, JE] = mfs_BE_t3(x, y)

# usage: [BE, JE] = mfs_BE_t3(x, y)
#
# Input  x, y     Arrays with nodal point coordinates
#
# Output BE       Strain-displacement matrix
#        JE       Jacobi determinant
#
# The function computes the strain-displacement matrix of a linear
# triangular isoparametric element with 3 nodes.
#
# -------------------------------------------------------------------

# Jacobi matrix

  Jmat = [ x(2) - x(1), y(2) - y(1);
           x(3) - x(1), y(3) - y(1)];

# Inverse Jacobi matrix

  JE   = abs(det(Jmat));
  Jinv = [Jmat(2, 2), - Jmat(1, 2);
          -Jmat(2, 1), Jmat(1, 1)] / JE;

# Strain-displacement matrix

  BE = [ y(2) - y(3), 0, y(3) - y(1), 0, y(1) - y(2), 0;
         0, x(3) - x(2), 0, x(1) - x(3), 0, x(2) - x(1);
         x(3) - x(2), y(2) - y(3), x(1) - x(3), y(3) - y(1), ...
         x(2) - x(1), y(1) - y(2)] / JE;

  return;

end
