function Gs = mfs_Gscale(G, A, geom)

# usage: Gs = mfs_Gscale(G, A, geom)
#
# Input  G      Shear modulus
#        A      Area of element
#        geom   Structure with geometric data
#
# Output Gs     Scaled shear modulus
#
# The function scales the shear modulus of a shell element
# depending on the length to thickness ratio so as to ensure
# convergence to the Kirchhoff theory when the elements become
# small.
#
# --------------------------------------------------------------------

# Define reference length to thickness ratio

  if (isfield(geom, "l2trat"))
     rratio = geom.l2trat;
  else
     rratio = 10;
  end

# Get actual length to thickness ratio

  ratio = sqrt(A) / geom.t;

# Scale shear modulus

  x  = (ratio / rratio)^2;
  s  = x / (1 + x) + 1 / x;
  Gs = s * G;

end
