function JE = mfs_JE_q4(r, s, x, y)

# usage: JE = mfs_JE_q4(r, s, x, y)
#
# Input  r, s     Parametric coordinates
#        x, y     Arrays with nodal point coordinates
#
# Output JE       Jacobi determinant
#
# The function computes the Jacobi determinant of a linear
# quadrilateral isoparametric element with 4 nodes.
#
# -------------------------------------------------------------------

# Derivatives of shape functions with respect to r, s

  sm = 0.25 * (1 - s);  sp = 0.25 * (1 + s);
  rm = 0.25 * (1 - r);  rp = 0.25 * (1 + r);

  nr = [-sm, sm, sp, -sp]; ns = [-rm, -rp, rp, rm];

# Jacobi matrix

  Jmat = [nr; ns] * [x, y];

# Jacobi determinant

  JE   = abs(det(Jmat));

end
