function JE = mfs_JE_t6(r, s, x, y)

# usage: JE = mfs_JE_t6(r, s, x, y)
#
# Input  r, s     Parametric coordinates
#        x, y     Arrays with nodal point coordinates
#
# Output JE       Jacobi determinant
#
# The function computes the Jaocib matrix of a quadratic
# triangular isoparametric element with 6 nodes.
#
# -------------------------------------------------------------------

# Derivatives of shape functions with respect to r, s

%  nr = zeros(1, 6); ns = zeros(1, 6);

  nr(4 : 6) = 4 * [ 1 - 2 * r - s, s, -s];
  ns(4 : 6) = 4 * [ -r, r, 1 - r - 2 * s];

  nr(1 : 3) = [ -1 - 0.5 * (nr(4) + nr(6)),
                 1 - 0.5 * (nr(4) + nr(5)),
                   -0.5 * (nr(5) + nr(6))];
  ns(1 : 3) = [ -1 - 0.5 * (ns(4) + ns(6)),
                    -0.5 * (ns(4) + ns(5)),
                 1 - 0.5 * (ns(5) + ns(6))];

# Jacobi matrix

  Jmat = [nr; ns] * [x, y];

# Jacobi determinant

  JE = abs(det(Jmat));

end
