function N = mfs_NE_q4(r, s)

# usage: N = mfs_NE_q4(r, s)
#
# Input  r, s   Parametric coordinates
#
# Output NE(4)  Interpolation matrix of one degree of freedom
#
# -------------------------------------------------------------------

# Shape functions

  sm = 1 - s;  sp = 1 + s;
  rm = 1 - r;  rp = 1 + r;

  N = 0.25 * [rm * sm, rp * sm, rp * sp, rm * sp];

  return;

end
