function N = mfs_NE_q8(r, s)

# usage: N = mfs_NE_q8(r, s)
#
# Input  r, s   Parametric coordinates
#
# Output NE(8)  Interpolation matrix of one degree of freedom
#
# -------------------------------------------------------------------

# Shape functions

%  N = zeros(1, 8);

  sm = 1 - s;  sp = 1 + s;
  rm = 1 - r;  rp = 1 + r;
  sq = sm * sp;  rq = rm * rp;

  N(5 : 8) = 0.5 * [rq * sm, rp * sq, rq * sp, rm * sq];
  N(1 : 4) = [ 0.25 * rm * sm - 0.5 * (N(5) + N(8)),
               0.25 * rp * sm - 0.5 * (N(5) + N(6)),
               0.25 * rp * sp - 0.5 * (N(6) + N(7)),
               0.25 * rm * sp - 0.5 * (N(7) + N(8))];

end
