function N = mfs_NE_q9(r, s)

# usage: N = mfs_NE_q9(r, s)
#
# Input  r, s   Parametric coordinates
#
# Output NE(9)  Interpolation matrix of one degree of freedom
#
# -------------------------------------------------------------------

# Shape functions

%  N = zeros(1, 9);

  sm = 1 - s;  sp = 1 + s;
  rm = 1 - r;  rp = 1 + r;
  sq = sm * sp;  rq = rm * rp;

  N9 = rq * sq; N(9) = N9;

  N(5 : 8) = 0.5 * [ rq * sm - N9,
                     rp * sq - N9,
                     rq * sp - N9,
                     rm * sq - N9];

  N9 = 0.25 * N9;
  N(1 : 4) = [ 0.25 * rm * sm - 0.5 * (N(5) + N(8)) - N9,
               0.25 * rp * sm - 0.5 * (N(5) + N(6)) - N9,
               0.25 * rp * sp - 0.5 * (N(6) + N(7)) - N9,
               0.25 * rm * sp - 0.5 * (N(7) + N(8)) - N9];

end
