function N = mfs_NE_t6(r, s)

# usage: N = mfs_NE_t6(r, s)
#
# Input  r, s   Parametric coordinates
#
# Output NE(6)  Interpolation matrix of one degree of freedom
#
# -------------------------------------------------------------------

# Shape functions

%  N = zeros(1, 6);

  rsm = 1 - r - s;

  N(4 : 6) = 4 * [r * rsm, r * s, s * rsm];
  
  N(1 : 3) = [ rsm - 0.5 * (N(4) + N(6)),
               r - 0.5 * (N(4) + N(5)),
               s - 0.5 * (N(5) + N(6))];

end;
