function rc = mfs_chkmat3d(msg, mat, id)

# usage: rc = mfs_chkmat3d(msg, mat, id)
#
# Input  msg  File handle of message file 
#        mat  Structure with material data
#        id   Element identifier
#
# Ouput  rc   Return code: 0 means no erros
#                          1 means erros
#
# The function checks the definition of 3-dimensional material data.
#
# -----------------------------------------------------------------------------

# Initialize

  fields = {"type", "E", "ny", "rho"};
  rc     = 0;

# Checks

   if (! mfs_checkfields2(msg, mat, fields(1), "Element", id))
      if (ischar(mat.type))
         switch mat.type
         case "iso"
            if (! mfs_checkfields2(msg, mat, fields(2 : 3), "Element", id))
               if (isreal(mat.E) && mat.E <= 0)
                  fprintf(msg, "*E* Element %6d: ", id);
                  fprintf(msg, "Illegal value of \"mat.E\"\n");
                  rc = 1;
               end
               if (isreal(mat.ny) && (mat.ny < 0 || mat.ny > 0.5))
                  fprintf(msg, "*E* Element %6d: ", id);
                  fprintf(msg, "Illegal value of \"mat.ny\"\n");
                  rc = 1;
               end
               if (isfield(mat, "rho") && isreal(mat.rho) && mat.rho < 0)
                  fprintf(msg, "*E* Element %6d: ", id);
                  fprintf(msg, "Illegal value of \"mat.rho\"\n");
                  rc = 1;
               end
            else
               rc = 1;
            end
            rc = rc | mfs_checkfields3(msg, mat, fields, "Element", id);
         otherwise
            fprintf(msg, "*E* Element %6d: Unknown material type \"%s\"\n", ...
                    id, mat.type);
            rc = 1;
         end
      else
         fprintf(msg, "*E* Element %6d: ", id);
         fprintf(msg, "Bad definition of material type\n");
         rc = 1;
      end
   else
      rc = 1;
   end

end
