function E = mfs_emat2d(mat, id)

# usage: E = mfs_emat2d(mat)
#
# Input  mat  Structure with material data
#
# Output E    Elastiticy matrix
#
# The function returns the elasticity matrix of an isotropic elastic
# 2-dimensional material.
#
# -------------------------------------------------------------------

# Material stiffness matrix

  ny = mat.ny;

  E = [ 1, ny, 0; ny, 1, 0; 0, 0, (1 - ny) / 2];
  E = E * mat.E / (1 - ny^2);

end
