function [r, s, w] = mfs_gauss2d(ng)

# usage: [r, s, w] = mfs_gauss2d(ng)
#
# Input  ng     Number of Gauss points
#
# Output r, s   Parametric coordinates of Gauss points
#        w      Weights
#
# The function returns the coordinates and weights of the
# Gauss points of a quadrilateral.
#
# -------------------------------------------------------------------

  switch ng
  case 1
     r = 0;
     s = 0;
     w = 4; 
  case 4
     f = 1 / sqrt(3);
     r = [ -f, f, -f, f];
     s = [ -f, -f, f, f];
     w = [ 1, 1, 1, 1]; 
  case 9
     f = sqrt(3/5);
     r = [ -f, 0, f, -f, 0, f, -f, 0, f];
     s = [ -f, -f, -f, 0, 0, 0, f, f, f];
     w = [ 25, 40, 25, 40, 64, 40, 25, 40, 25] / 81;
  otherwise
     error("mfs_gauss2d: ng = %d not implemented\n", ng);
  end

  return

end
