function [r, s, w] = mfs_gausstr(ng)

# usage: [r, s, w] = mfs_gausstr(ng)
#
# Input  ng     Number of Gauss points
#
# Output r, s   Parametric coordinates of Gauss points
#        w      Weights
#
# The function returns the coordinates and weights of the
# Gauss points of a triangle.
#
# -------------------------------------------------------------------

  switch ng
  case 1
     x = 1 / 3;
     r = x; 
     s = x;
     w = 0.5;
  case 3
     r = [0.5, 0.5, 0];
     s = [0, 0.5, 0.5];
     w = [1, 1, 1] / 6;
  otherwise
     error("mfs_gausstr: ng = %d not implemented\n", ng);
  end

  return

end
