function mfs_prtresultant_r2(fid, nofelt, elem, lc, type)

# usage: mfs_prtresultant_r2(fid, nofelt, elem, lc, type)
#
# Input  fid       File handle
#        nofelt    Number of elements
#        elem(:)   Structure with element results
#        lc        Loadcase
#        type      Result type: 0 = real
#                               1 = complex
#
# This function prints the stress resultants of rod elements.
#
# ------------------------------------------------------------------------

  switch type

  case 0

     fprintf(fid, "  Rod elements:\n\n");
     fprintf(fid, "  element       N   \n");
     fprintf(fid, "  --------------------\n");

     for nel = 1 : nofelt
         fprintf(fid, "   %6d  %10.3e\n", ...
                 elem(nel).id, elem(nel).results.rslt(lc));
     end

     fprintf(fid, "\n");

  case 1

     fprintf(fid, "  Rod elements:\n\n");
     fprintf(fid, "  element           N   \n");
     fprintf(fid, "  ------------------------\n");

     for nel = 1 : nofelt
         fprintf(fid, "   %6d Re  %10.3e\n", ...
                 elem(nel).id, real(elem(nel).results.rslt(lc)));
         fprintf(fid, "          Im  %10.3e\n", ...
                 imag(elem(nel).results.rslt(lc)));
     end

     fprintf(fid, "\n");

  end

end
