function mfs_prtresultant_shell(fid, nofelt, elem, l, type)

# usage: mfs_prtresultant_shell(fid, nofelt, elem, l, type)
#
# Input  fid       File handle
#        nofelt    Number of elements
#        elem(:)   Structure with element results
#        l         Column number
#        type      Result type: 0 = real
#                               1 = complex
#
# This function prints the stress resultants of shell elements.
#
# ------------------------------------------------------------------------

  line = "------------\n";

  switch type

  case 0

     fmt1 = "  %2d  %10.3e  %10.3e  %10.3e  %10.3e\n";
     fmt2 = "%10.3e  %10.3e  %10.3e  %10.3e\n";
     fmts = "                ";

     fprintf(fid, "  Shell elements:\n\n");
     fprintf(fid, "  element  point");
     fprintf(fid, "     Nx /        Ny /        Nxy /       Qx /\n")
     fprintf(fid, fmts);
     fprintf(fid, "     Mx          My          Mxy         Qy\n");
     fprintf(fid, "  ------------------------------------------------");
     fprintf(fid, line);

     for nel = 1 : nofelt
         elt = elem(nel);
         fprintf(fid, "   %6d ", elt.id);
         for k = 1 : elt.nofpnt
             fprintf(fid, fmt1, k, elt.results.rslt([1 : 3, 7], l, k));
             fprintf(fid, fmts); 
             fprintf(fid, fmt2, elt.results.rslt([4 : 6, 8], l, k));
         end
     end

     fprintf(fid, "\n");

  case 1

     fmt1 = "  %2d Re %10.3e  %10.3e  %10.3e  %10.3e\n";
     fmt2 = "   %10.3e  %10.3e  %10.3e  %10.3e\n";
     fmt3 = "Im %10.3e  %10.3e  %10.3e  %10.3e\n";
     fmts = "               ";

     fprintf(fid, "  Shell elements:\n\n");
     fprintf(fid, "  element  point");
     fprintf(fid, "       Nx /        Ny /        Nxy /       Qx /\n")
     fprintf(fid, fmts);
     fprintf(fid, "        Mx          My          Mxy         Qy\n");
     fprintf(fid, "  ---------------------------------------------------");
     fprintf(fid, line);

     for nel = 1 : nofelt
         elt = elem(nel);
         fprintf(fid, "   %6d ", elt.id);
         for k = 1 : elt.nofpnt
             fprintf(fid, fmt1, k, 
                     real(elt.results.rslt([1 : 3, 7], l, k)));
             fprintf(fid, fmts); 
             fprintf(fid, fmt2, 
                    real( elt.results.rslt([4 : 6, 8], l, k)));
             fprintf(fid, fmts); 
             fprintf(fid, fmt3, 
                    imag( elt.results.rslt([1 : 3, 7], l, k)));
             fprintf(fid, fmts); 
             fprintf(fid, fmt2, 
                    imag( elt.results.rslt([4 : 6, 8], l, k)));
         end
     end

     fprintf(fid, "\n");

  end

end
