function mfs_prtstrain_shell(fid, nofelt, elem, l, type)

# usage: mfs_prtstrain_shell(fid, nofelt, elem, l, type)
#
# Input  fid       File handle
#        nofelt    Number of elements
#        elem(:)   Structure with element results
#        l         Loadcase of excitation frequency
#        type      Result type: 0 = real
#                               1 = complex
#
# This function prints the strains of shell elements.
#
# ------------------------------------------------------------------------

  line  = "------------------- \n";

  switch type

  case 0

     fprintf(fid, "  Shell elements:\n\n");
     fprintf(fid, "  element  point  side  ");
     fprintf(fid, "     epsx        epsy       gammaxy \n");
     fprintf(fid, "  ---------------------------------------");
     fprintf(fid, line);

     for nel = 1 : nofelt
         elt = elem(nel);
         fprintf(fid, "   %6d ", elt.id);
         for k = 1 : elt.nofpnt
             fprintf(fid, "  %2d    upper   %10.3e  %10.3e  %10.3e\n",
                     k, elt.results.eps(:, l, 1, k));
             fprintf(fid, "                  ");
             fprintf(fid, "lower   %10.3e  %10.3e  %10.3e\n",
                     elt.results.eps(:, l, 2, k));
         end
     end

     fprintf(fid, "\n");

  case 1

     fprintf(fid, "  Shell elements:\n\n");
     fprintf(fid, "  element  point  side  ");
     fprintf(fid, "        epsx        epsy       gammaxy \n");
     fprintf(fid, "  ------------------------------------------");
     fprintf(fid, line);

     for nel = 1 : nofelt
         elt = elem(nel);
         fprintf(fid, "   %6d ", elt.id);
         for k = 1 : elt.nofpnt
             fprintf(fid, "  %2d    upper Re  %10.3e  %10.3e  %10.3e\n",
                     k, real(elt.results.eps(:, l, 1, k)));
             fprintf(fid, "                  ");
             fprintf(fid, "      Im  %10.3e  %10.3e  %10.3e\n",
                     imag(elt.results.eps(:, l, 1, k)));
             fprintf(fid, "                  ");
             fprintf(fid, "lower Re  %10.3e  %10.3e  %10.3e\n",
                     real(elt.results.eps(:, l, 2, k)));
             fprintf(fid, "                  ");
             fprintf(fid, "      Im  %10.3e  %10.3e  %10.3e\n",
                     imag(elt.results.eps(:, l, 2, k)));
         end
     end

     fprintf(fid, "\n");

  end

end
