function mfs_prtstress_membrane(fid, nofelt, elem, l, type)

# usage: mfs_prtstress_membrane(fid, nofelt, elem, l, type)
#
# Input  fid       File handle
#        nofelt    Number of elements
#        elem(:)   Structure with element results
#        l         Loadcase or frequency index
#        type      Result type: 0 = real
#                               1 = complex
#
# This function prints the stresses of membrane elements.
#
# ------------------------------------------------------------------------

  ndim = columns(elem(1).coor);

  if (ndim == 2)
     tcoor = "  element  point      x         y   ";
     fmt1  = "   %6d    %2d   %8.2f  %8.2f";
     fmt2  = "             %2d   %8.2f  %8.2f";
     line  = "------------------------------- \n";
     blank = "                                    ";
  else
     tcoor = "  element  point      x         y         z   ";
     fmt1  = "   %6d    %2d   %8.2f  %8.2f  %8.2f";
     fmt2  = "             %2d   %8.2f  %8.2f  %8.2f";
     line  = "----------------------------------------- \n";
     blank = "                                              ";
  end

  switch type

  case 0

     fprintf(fid, "  Membrane elements:\n\n");
     fprintf(fid, tcoor);
     fprintf(fid, "     sigx        sigy        tauxy  \n");
     fprintf(fid, "  ---------------------------------------");
     fprintf(fid, line);

     for nel = 1 : nofelt
         elt = elem(nel);
         fprintf(fid, fmt1, elt.id, 1, elt.coor(1, :))
         fprintf(fid, "  %10.3e  %10.3e  %10.3e\n",
                 elt.results.sig(:, l, 1));
         for k = 2 : elt.nofpnt
             fprintf(fid, fmt2, k, elt.coor(k, :))
             fprintf(fid, "  %10.3e  %10.3e  %10.3e\n",
                     elt.results.sig(:, l, k));
         end
     end

     fprintf(fid, "\n");

  case 1

     fprintf(fid, "  Membrane elements:\n\n");
     fprintf(fid, tcoor);
     fprintf(fid, "        sigx        sigy        tauxy  \n");
     fprintf(fid, "  ------------------------------------------");
     fprintf(fid, line);

     for nel = 1 : nofelt
         elt = elem(nel);
         fprintf(fid, fmt1, elt.id, 1, elt.coor(1, :))
         fprintf(fid, " Re  %10.3e  %10.3e  %10.3e\n",
                 real(elt.results.sig(:, l, 1)));
         fprintf(fid, blank);
         fprintf(fid, " Im  %10.3e  %10.3e  %10.3e\n",
                 imag(elt.results.sig(:, l, 1)));
         for k = 2 : elt.nofpnt
             fprintf(fid, fmt2, k, elt.coor(k, :))
             fprintf(fid, " Re  %10.3e  %10.3e  %10.3e\n",
                     real(elt.results.sig(:, l, k)));
             fprintf(fid, blank);
             fprintf(fid, " Im  %10.3e  %10.3e  %10.3e\n",
                     imag(elt.results.sig(:, l, k)));
         end
     end

     fprintf(fid, "\n");

  end

end
