function mfs_prtstress_shell(fid, nofelt, elem, l, type)

# usage: mfs_prtstress_shell(fid, nofelt, elem, l, type)
#
# Input  fid       File handle
#        nofelt    Number of elements
#        elem(:)   Structure with element results
#        l         Column number
#        type      Result type: 0 = real
#                               1 = complex
#
# This function prints the stresses of shell elements.
#
# ------------------------------------------------------------------------

  line  = "------------------- \n";

  switch type

  case 0

     fprintf(fid, "  Shell elements:\n\n");
     fprintf(fid, "  element  point  side  ");
     fprintf(fid, "     sigx        sigy        tauxy  \n");
     fprintf(fid, "  ---------------------------------------");
     fprintf(fid, line);

     for nel = 1 : nofelt
         elt = elem(nel);
         fprintf(fid, "   %6d ", elt.id);
         for k = 1 : elt.nofpnt
             fprintf(fid, "  %2d    upper   %10.3e  %10.3e  %10.3e\n",
                     k, elt.results.sig(:, l, 1, k));
             fprintf(fid, "                  ");
             fprintf(fid, "lower   %10.3e  %10.3e  %10.3e\n",
                     elt.results.sig(:, l, 2, k));
         end
     end

     fprintf(fid, "\n");

  case 1

     fprintf(fid, "  Shell elements:\n\n");
     fprintf(fid, "  element  point  side  ");
     fprintf(fid, "        sigx        sigy        tauxy  \n");
     fprintf(fid, "  ------------------------------------------");
     fprintf(fid, line);

     for nel = 1 : nofelt
         elt = elem(nel);
         fprintf(fid, "   %6d ", elt.id);
         for k = 1 : elt.nofpnt
             fprintf(fid, "  %2d    upper Re  %10.3e  %10.3e  %10.3e\n",
                     k, real(elt.results.sig(:, l, 1, k)));
             fprintf(fid, "                  ");
             fprintf(fid, "      Im  %10.3e  %10.3e  %10.3e\n",
                     imag(elt.results.sig(:, l, 1, k)));
             fprintf(fid, "                  ");
             fprintf(fid, "lower Re  %10.3e  %10.3e  %10.3e\n",
                     real(elt.results.sig(:, l, 2, k)));
             fprintf(fid, "                  ");
             fprintf(fid, "      Im  %10.3e  %10.3e  %10.3e\n",
                     imag(elt.results.sig(:, l, 2, k)));
         end
     end

     fprintf(fid, "\n");

  end

end
