function Trm = mfs_rot2mid2d(coor)

# usage: Trm = mfs_rot2mid2d(coor)
#
# Input  coor(np, 2)       Element node coordinates
#
# Output Trm(4*np, 3*np)   Transformation matrix from R-element to
#                          quadratic element
#
# The function computes the transformation matrix from the degrees of
# freedom of a t3r or q4r element to the degrees of freedom of a t3
# or q4 element.
#
# -------------------------------------------------------------------

# Initialize

  np  = rows(coor);
  m   = 4 * np; n = 3 * np;
  Trm = zeros(m, n);

  ia = 1 : np; ib = [ia(2 : end), ia(1)];

# Fill in ones for corner node displacements

  ic = 1; ir = 1;
  for n = 1 : np
      Trm(ir++, ic++) = 1;
      Trm(ir++, ic++) = 1;
      ic++;
  end

# Compute edge vectors

  E = coor(ib, :) - coor(ia, :);

# Compute midpoint interpolation matrices

  ir = 2 * np + 1;

  for n = 1 : np

      rr = [ir, ir + 1];

      ic = 3 * (ia(n) - 1) + 1;
      cc = [ic : ic + 2];
      Trm(rr, cc) = [0.5, 0, -0.125 * E(n, 2); 
                     0, 0.5, 0.125 * E(n, 1)];

      ic = 3 * (ib(n) - 1) + 1;
      cc = [ic : ic + 2];
      Trm(rr, cc) = [0.5, 0, 0.125 * E(n, 2); 
                     0, 0.5, -0.125 * E(n, 1)];

      ir += 2;

  end

end
