function [cs, mxdofpnt, rc] = mfs_cs(msg, nc, lcinp, nodes)

# usage: [cs, mxdofpnt, rc] = mfs_cs(msg, nc, lcinp, nodes)
#
# Input  msg      File handle of message file
#        nc       Number of constraint (e.g. for error messages)
#        lcinp    Structure with definition of linear constraint
#        nodes    Structure with nodal point data 
#                 (see the Programmer's Manual)
#
# Output cs       Structure with constraint matrix
#        mxdofpnt Maximum number of degrees of freedom per nodal
#                 point
#        rc       Return code: 0 means no errors
#                              1 means errors
#
# Structure lcinp contains the data of the linear constraint
# as defined in the model description.
#
# The output structure cs has the following fields:
#
#   dofa(2, :)  Autonomous degrees of freedom:
#                 internal nodal point identifier, dof identifier
#   dofd(2, :)  Dependent degrees of freedom:
#                 internal nodal point identifier, dof identifier
#   C(:, :)    Constraint matrix of one constraint
#              (rows = dep. dofs, cols = autonomous dofs)
#
# -------------------------------------------------------------------

# Initialize

  mxdofpnt = 0;
  cs       = struct("dofa", [], "dofd", [], "C", []);
  rc       = 0;

# Check for unknown fields


# Check input data


# Build degree of freedom arrays


# Build constraint matrix

  
# Build the constraint structure


end
