function mfs_arrow2d(sp, len, axis, color, label, fontsize)

# usage: mfs_arrow2d(sp, len, axis, color, label, fontsize)
#
# Input  sp(2)     Coordinates of start point
#        len       Length 
#        axis      Axis: "x" or "y"
#        color     Color
#        label     Label (optional)
#        fontsize  Fontsize for label
#
# This function draws an arrow in x- or y-direction.
#
# -------------------------------------------------------------------

# End Points

  lenl =  0.8 * len;
  lens = 0.05 * len;
  
  switch axis
     case "x"
        ep = sp + [len, 0];
        p1 = sp + [lenl, lens];
        p2 = sp + [lenl, -lens];
        if (len > 0)
           hzal = "left";
        else
           hzal = "right";
        end
        vtal = "bottom";
     case "y"
        ep = sp + [0, len];
        p1 = sp + [-lens, lenl];
        p2 = sp + [lens, lenl];
        hzal = "left";
        if (len > 0)
           vtal = "bottom";
        else
           vtal = "top";
        end
     otherwise
        error("mfs_arrow2d: %s is an illegal axis value", axis);
  end

# Lines

  line([sp(1), ep(1)], [sp(2), ep(2)], "linewidth", 2, "color", color);
  line([ep(1), p1(1)], [ep(2), p1(2)], "linewidth", 2, "color", color);
  line([ep(1), p2(1)], [ep(2), p2(2)], "linewidth", 2, "color", color);

# Label

  if (nargin > 4)
%     p3 = p2 + [0, -2 * lens];
     p3 = sp + 1.1 * (ep - sp);
     text(p3(1), p3(2), label,
          "color", color, "fontsize", fontsize,
          "horizontalalignment", hzal,
          "verticalalignment", vtal);
  end

end
