function mfs_arrow3d(sp, len, axis, color, label, fontsize)

# usage: mfs_arrow3d(sp, len, axis, color, label, fontsize)
#
# Input  sp(3)     Coordinates of start point
#        len       Length 
#        axis      Axis: "x" or "y"
#        color     Color
#        label     Label (optional)
#        fontsize  Fontsize for label
#
# This function draws an arrow in x- or y-direction.
#
# -------------------------------------------------------------------

# End Points

  lenl =  0.8 * len;
  lens = 0.05 * len;
  
  switch axis
     case "x"
        ep = sp + [len, 0, 0];
        p1 = sp + [lenl, 0, lens];
        p2 = sp + [lenl, 0 -lens];
     case "y"
        ep = sp + [0, len, 0];
        p1 = sp + [0, lenl, lens];
        p2 = sp + [0, lenl, -lens];
     case "z"
        ep = sp + [0, 0, len];
        p1 = sp + [-lens, 0, lenl];
        p2 = sp + [ lens, 0, lenl];
     otherwise
        error("mfs_arrow3d: %s is an illegal axis value", axis);
  end

# Lines

  line([sp(1), ep(1)], [sp(2), ep(2)], [sp(3), ep(3)], ...
       "linewidth", 2, "color", color);
  line([ep(1), p1(1)], [ep(2), p1(2)], [ep(3), p1(3)], ...
       "linewidth", 2, "color", color);
  line([ep(1), p2(1)], [ep(2), p2(2)], [ep(3), p2(3)], ...
       "linewidth", 2, "color", color);

# Label

  if (nargin > 4)
     p3 = p2 + [0, -2 * lens, 0];
     text(p3(1), p3(2), p3(3), label, ...
          "color", color, "fontsize", fontsize, ...
          "backgroundcolor", "white");
  end

end
