function rc = mfs_chk_respcase(casno, maxno, resp)

# usage: rc = mfs_chk_respcase(casno, maxno, resp)
#
# Input  casno        Result case number
#        maxno        Maximum result case number
#        resp{maxno}  Cell array with results
#
# Output rc           Return code: 0 = no errors
#                                  1 = errors
#
# The function checks, if there are results for result case casno.
#
# -------------------------------------------------------------------------

  rc = 1;

  if (casno < 1 || casno > maxno)
     printf("*E* mfs_getresp: result case %d does not exist\n", casno);
     return;
  end

  if (isempty(resp{casno}))
     printf("*E* mfs_getresp: result case %d does not exist\n", casno);
     return;
  end

  rc = 0;

end
