function [damp, rc] = mfs_damping(msg, damping)

# usage: [damp, rc] = mfs_damping(msg, damping) 
#
# Input  msg       File handle of message file
#        damping   Structure with definition of damping
#
# Output damp      Structure with definition of damping
#        rc        Return code: 0 = no errors
#                               1 = errors
#
# The function builds the damping structure from the input data.
#
# ------------------------------------------------------------------------

# Check arguments

  if (nargin != 2 || nargout != 2)
     print_usage();
  end

# Initialize

  damp = 0;

# Check input data

  if ((rc = mfs_checkfields1(msg, damping, {"type", "data"}, "Damping")))
     return;
  end

# Process damping

  switch damping.type

  case "Rayleigh"

     nd = length(damping.data);
     if (nd == 2)
        data = damping.data;
     else
        rc = 1;
        fprintf(msg, "*E* Definition of Rayleigh damping contains ");
        fprintf(msg, "%d instead of 2 values", nd);
     end

  case "ratios"

     if (isnumeric(damping.data))
        data = damping.data;
     elseif (iscell(damping.data))
        k = 1;
        for d = damping.data
            c = d{1};
            ln = length(c);
            if (ln == 1)
               data(k++) = c;      
            elseif (ln == 2)
               n = c{1};
               for m = 1 : n
                   data(k++) = c{2};
               end
            else
               rc = 1;
               fprintf(msg, "*E* Bad definition of damping ratios\n");
            end 
        end
     else
        rc = 1;
        fprintf(msg, "*E* Bad definition of damping ratios\n");
     end

  otherwise

     rc = 1;
     fprintf(msg, "*E* Unknown damping type ""%s""\n", damping.type);

  end

# Build the damping structure

  if (! rc)
     damp = struct("type", damping.type, "data", data);
  end

end
