function [typedata, rc] = mfs_eldata(msg, eltnam, epath)

# usage: [typedata, rc] = mfs_eldata(msg, eltnam, epath)
#
# Input  msg        File handle of message file
#        eltnam     Name of element type
#        epath      Path to element routines
#
# Output typedata   Structure with element type data:
#                   name     element name
#                   nelnod   number of element nodes
#                   ndofnod  number of dofs per node
#                   mat      indicates if material data are needed (0 or 1) 
#                   geom     indicates if geometrical data are needed (0 or 1)
#                   gmshid   gmsh element type
#                   rtype    result type
#                   axes     axes type
#        rc         Return code: 1 in case of error
#
# The function returns the data of the element type requested.
#
# -----------------------------------------------------------------------------

  eltpath = strcat(epath, eltnam);

  if (exist(eltpath, "dir"))
     rc = 0;
     addpath(eltpath);
     typedata = mfs_defelt();
     rmpath(eltpath);
  else
     fprintf(msg, "*E* Unknown element type \"%s\" found\n", eltnam);
     rc = 1;
     typedata = struct();
  end

end
